// PCW99_ODBC_Generic_OLTP_Read_Join.cpp

#include "stdafx.h"
#include "PCW99_ODBC_Generic.h"
#include "PCW99_ODBC_Generic_OLTP_Read_Join.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_05,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_06,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_07,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_08,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_09,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_10,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_11,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_12,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_13,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_14,CXact,1)

// ================================================================================

// CXact_OLTP_Read_Join_01

CXact_OLTP_Read_Join_01::CXact_OLTP_Read_Join_01 (void)
{
	m_szName		= "OLTP Read Join 01";
	m_szDescription = "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where updates.p_key = :randbase and updates.p_key = hundred.h_key";
	m_szSQL			= "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where updates.p_key = ? and updates.p_key = hundred.h_key";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+01;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_01::~CXact_OLTP_Read_Join_01 (void)
{
}

BOOL CXact_OLTP_Read_Join_01::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_01::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_01::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;
	struct OLTP_READ_JOIN_01 {
		SQLINTEGER p_key;
		SQLCHAR p_code[15];
		SQLCHAR h_date[35];
		SQLINTEGER h_signed;
		SQLCHAR h_name[25];
		SQLCHAR h_address[85];
	};
	typedef struct OLTP_READ_JOIN_01 OLTP_READ_JOIN_01;
	struct OLTP_READ_JOIN_01_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_code;
		SQLINTEGER h_date;
		SQLINTEGER h_signed;
		SQLINTEGER h_name;
		SQLINTEGER h_address;
	};
	typedef struct OLTP_READ_JOIN_01_INDICATORS OLTP_READ_JOIN_01_INDICATORS;
	OLTP_READ_JOIN_01 oltp_read_join_01_array[NUM_ROWS];
	OLTP_READ_JOIN_01_INDICATORS oltp_read_join_01_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_01_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_01_array[0].p_key, sizeof(oltp_read_join_01_array[0].p_key), &oltp_read_join_01_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_01_array[0].p_code, sizeof(oltp_read_join_01_array[0].p_code), &oltp_read_join_01_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_01_array[0].h_date, sizeof(oltp_read_join_01_array[0].h_date), &oltp_read_join_01_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_join_01_array[0].h_signed, sizeof(oltp_read_join_01_array[0].h_signed), &oltp_read_join_01_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_join_01_array[0].h_name, sizeof(oltp_read_join_01_array[0].h_name), &oltp_read_join_01_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_join_01_array[0].h_address, sizeof(oltp_read_join_01_array[0].h_address), &oltp_read_join_01_indicators_array[0].h_address);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_01_array[iRowLoop].p_key << tab
					<< oltp_read_join_01_array[iRowLoop].p_code << tab
					<< oltp_read_join_01_array[iRowLoop].h_date << tab
					<< oltp_read_join_01_array[iRowLoop].h_signed << tab
					<< oltp_read_join_01_array[iRowLoop].h_name << tab
					<< oltp_read_join_01_array[iRowLoop].h_address << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_02

CXact_OLTP_Read_Join_02::CXact_OLTP_Read_Join_02 (void)
{
	m_szName		= "OLTP Read Join 02";
	m_szDescription = "select twomill.p_key, twomill.p_code, uniques.u_date, uniques.u_signed, uniques.u_name from twomill, uniques where twomill.p_key = :randtwomill and twomill.p_code = uniques.u_code";
	m_szSQL			= "select twomill.p_key, twomill.p_code, uniques.u_date, uniques.u_signed, uniques.u_name from twomill, uniques where twomill.p_key = ? and twomill.p_code = uniques.u_code";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+02;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_02::~CXact_OLTP_Read_Join_02 (void)
{
}

BOOL CXact_OLTP_Read_Join_02::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_02::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_02::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randtwomill;
	struct OLTP_READ_JOIN_02 {
		SQLINTEGER p_key;
		SQLCHAR p_code[15];
		SQLCHAR u_date[35];
		SQLINTEGER u_signed;
		SQLCHAR u_name[25];
	};
	typedef struct OLTP_READ_JOIN_02 OLTP_READ_JOIN_02;
	struct OLTP_READ_JOIN_02_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_code;
		SQLINTEGER u_date;
		SQLINTEGER u_signed;
		SQLINTEGER u_name;
	};
	typedef struct OLTP_READ_JOIN_02_INDICATORS OLTP_READ_JOIN_02_INDICATORS;
	OLTP_READ_JOIN_02 oltp_read_join_02_array[NUM_ROWS];
	OLTP_READ_JOIN_02_INDICATORS oltp_read_join_02_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_02_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randtwomill, sizeof(randtwomill), &BindParamInd);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_02_array[0].p_key, sizeof(oltp_read_join_02_array[0].p_key), &oltp_read_join_02_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_02_array[0].p_code, sizeof(oltp_read_join_02_array[0].p_code), &oltp_read_join_02_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_02_array[0].u_date, sizeof(oltp_read_join_02_array[0].u_date), &oltp_read_join_02_indicators_array[0].u_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_join_02_array[0].u_signed, sizeof(oltp_read_join_02_array[0].u_signed), &oltp_read_join_02_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_join_02_array[0].u_name, sizeof(oltp_read_join_02_array[0].u_name), &oltp_read_join_02_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randtwomill = (long) m_CRandom.GetRandom(2,RANDTWOMILL);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_02_array[iRowLoop].p_key << tab
					<< oltp_read_join_02_array[iRowLoop].p_code << tab
					<< oltp_read_join_02_array[iRowLoop].u_date << tab
					<< oltp_read_join_02_array[iRowLoop].u_signed << tab
					<< oltp_read_join_02_array[iRowLoop].u_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_03

CXact_OLTP_Read_Join_03::CXact_OLTP_Read_Join_03 (void)
{
	m_szName		= "OLTP Read Join 03";
	m_szDescription = "select fivemill.h_key, fivemill.h_code, updates.p_date, updates.p_signed, updates.p_name from fivemill, updates where fivemill.h_key in (:randfivemill1,:randfivemill2,:randfivemill3,:randfivemill4,:randfivemill5) and fivemill.h_key = updates.p_key order by fivemill.h_code";
	m_szSQL			= "select fivemill.h_key, fivemill.h_code, updates.p_date, updates.p_signed, updates.p_name from fivemill, updates where fivemill.h_key in (?,?,?,?,?) and fivemill.h_key = updates.p_key order by fivemill.h_code";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+03;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_03::~CXact_OLTP_Read_Join_03 (void)
{
}

BOOL CXact_OLTP_Read_Join_03::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_03::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_03::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd1;
	SQLINTEGER BindParamInd2;
	SQLINTEGER BindParamInd3;
	SQLINTEGER BindParamInd4;
	SQLINTEGER BindParamInd5;
	unsigned long randfivemill1;
	unsigned long randfivemill2;
	unsigned long randfivemill3;
	unsigned long randfivemill4;
	unsigned long randfivemill5;
	struct OLTP_READ_JOIN_03 {
		SQLINTEGER h_key;
		SQLCHAR h_code[15];
		SQLCHAR p_date[35];
		SQLINTEGER p_signed;
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_JOIN_03 OLTP_READ_JOIN_03;
	struct OLTP_READ_JOIN_03_INDICATORS {
		SQLINTEGER h_key;
		SQLINTEGER h_code;
		SQLINTEGER p_date;
		SQLINTEGER p_signed;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_JOIN_03_INDICATORS OLTP_READ_JOIN_03_INDICATORS;
	OLTP_READ_JOIN_03 oltp_read_join_03_array[NUM_ROWS];
	OLTP_READ_JOIN_03_INDICATORS oltp_read_join_03_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd1 = IGNORE;
	BindParamInd2 = IGNORE;
	BindParamInd3 = IGNORE;
	BindParamInd4 = IGNORE;
	BindParamInd5 = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_03_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill1, sizeof(randfivemill1), &BindParamInd1);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill2, sizeof(randfivemill2), &BindParamInd2);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 3, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill3, sizeof(randfivemill3), &BindParamInd3);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 4, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill4, sizeof(randfivemill4), &BindParamInd4);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 5, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill4, sizeof(randfivemill5), &BindParamInd5);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_03_array[0].h_key, sizeof(oltp_read_join_03_array[0].h_key), &oltp_read_join_03_indicators_array[0].h_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_03_array[0].h_code, sizeof(oltp_read_join_03_array[0].h_code), &oltp_read_join_03_indicators_array[0].h_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_03_array[0].p_date, sizeof(oltp_read_join_03_array[0].p_date), &oltp_read_join_03_indicators_array[0].p_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_join_03_array[0].p_signed, sizeof(oltp_read_join_03_array[0].p_signed), &oltp_read_join_03_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_join_03_array[0].p_name, sizeof(oltp_read_join_03_array[0].p_name), &oltp_read_join_03_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randfivemill1 = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);
	randfivemill2 = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);
	randfivemill3 = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);
	randfivemill4 = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);
	randfivemill5 = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_03_array[iRowLoop].h_key << tab
					<< oltp_read_join_03_array[iRowLoop].h_code << tab
					<< oltp_read_join_03_array[iRowLoop].p_date << tab
					<< oltp_read_join_03_array[iRowLoop].p_signed << tab
					<< oltp_read_join_03_array[iRowLoop].p_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_04

CXact_OLTP_Read_Join_04::CXact_OLTP_Read_Join_04 (void)
{
	m_szName		= "OLTP Read Join 04";
	m_szDescription = "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where (hundred.h_key between :randbase and :randbaseplus) and updates.p_key = hundred.h_key order by updates.p_code, hundred.h_date";
	m_szSQL			= "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where (hundred.h_key between ? and ?) and updates.p_key = hundred.h_key order by updates.p_code, hundred.h_date";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+04;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_04::~CXact_OLTP_Read_Join_04 (void)
{
}

BOOL CXact_OLTP_Read_Join_04::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_04::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_04::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd1;
	SQLINTEGER BindParamInd2;
	unsigned long randbase;
	unsigned long randbaseplus;
	struct OLTP_READ_JOIN_04 {
		SQLINTEGER p_key;
		SQLCHAR p_code[15];
		SQLCHAR h_date[35];
		SQLINTEGER h_signed;
		SQLCHAR h_name[25];
		SQLCHAR h_address[85];
	};
	typedef struct OLTP_READ_JOIN_04 OLTP_READ_JOIN_04;
	struct OLTP_READ_JOIN_04_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_code;
		SQLINTEGER h_date;
		SQLINTEGER h_signed;
		SQLINTEGER h_name;
		SQLINTEGER h_address;
	};
	typedef struct OLTP_READ_JOIN_04_INDICATORS OLTP_READ_JOIN_04_INDICATORS;
	OLTP_READ_JOIN_04 oltp_read_join_04_array[NUM_ROWS];
	OLTP_READ_JOIN_04_INDICATORS oltp_read_join_04_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd1 = IGNORE;
	BindParamInd2 = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_04_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd1);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbaseplus, sizeof(randbaseplus), &BindParamInd2);
	CHECK_FOR_ERROR (hstmt);

	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_04_array[0].p_key, sizeof(oltp_read_join_04_array[0].p_key), &oltp_read_join_04_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_04_array[0].p_code, sizeof(oltp_read_join_04_array[0].p_code), &oltp_read_join_04_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_04_array[0].h_date, sizeof(oltp_read_join_04_array[0].h_date), &oltp_read_join_04_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_join_04_array[0].h_signed, sizeof(oltp_read_join_04_array[0].h_signed), &oltp_read_join_04_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_join_04_array[0].h_name, sizeof(oltp_read_join_04_array[0].h_name), &oltp_read_join_04_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_join_04_array[0].h_address, sizeof(oltp_read_join_04_array[0].h_address), &oltp_read_join_04_indicators_array[0].h_address);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE);
	randbaseplus = randbase + 20;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_04_array[iRowLoop].p_key << tab
					<< oltp_read_join_04_array[iRowLoop].p_code << tab
					<< oltp_read_join_04_array[iRowLoop].h_date << tab
					<< oltp_read_join_04_array[iRowLoop].h_signed << tab
					<< oltp_read_join_04_array[iRowLoop].h_name << tab
					<< oltp_read_join_04_array[iRowLoop].h_address << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_05

CXact_OLTP_Read_Join_05::CXact_OLTP_Read_Join_05 (void)
{
	m_szName		= "OLTP Read Join 05";
	m_szDescription = "select uniques.u_key, uniques.u_name, tenpct.t_key, tenpct.t_signed from uniques, tenpct where uniques.u_key >= 1000000000 and tenpct.t_int <= uniques.u_int and tenpct.t_key >= 999990000";
	m_szSQL			= "select uniques.u_key, uniques.u_name, tenpct.t_key, tenpct.t_signed from uniques, tenpct where uniques.u_key >= 1000000000 and tenpct.t_int <= uniques.u_int and tenpct.t_key >= 999990000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+05;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_05::~CXact_OLTP_Read_Join_05 (void)
{
}

BOOL CXact_OLTP_Read_Join_05::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_05::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_05::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_05 {
		SQLINTEGER u_key;
		SQLCHAR u_name[25];
		SQLINTEGER t_key;
		SQLINTEGER t_signed;
	};
	typedef struct OLTP_READ_JOIN_05 OLTP_READ_JOIN_05;
	struct OLTP_READ_JOIN_05_INDICATORS {
		SQLINTEGER u_key;
		SQLINTEGER u_name;
		SQLINTEGER t_key;
		SQLINTEGER t_signed;
	};
	typedef struct OLTP_READ_JOIN_05_INDICATORS OLTP_READ_JOIN_05_INDICATORS;
	OLTP_READ_JOIN_05 oltp_read_join_05_array[NUM_ROWS];
	OLTP_READ_JOIN_05_INDICATORS oltp_read_join_05_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_05_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_05_array[0].u_key, sizeof(oltp_read_join_05_array[0].u_key), &oltp_read_join_05_indicators_array[0].u_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_05_array[0].u_name, sizeof(oltp_read_join_05_array[0].u_name), &oltp_read_join_05_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_05_array[0].t_key, sizeof(oltp_read_join_05_array[0].t_key), &oltp_read_join_05_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_join_05_array[0].t_signed, sizeof(oltp_read_join_05_array[0].t_signed), &oltp_read_join_05_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_05_array[iRowLoop].u_key << tab
					<< oltp_read_join_05_array[iRowLoop].u_name << tab
					<< oltp_read_join_05_array[iRowLoop].t_key << tab
					<< oltp_read_join_05_array[iRowLoop].t_signed << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_06

CXact_OLTP_Read_Join_06::CXact_OLTP_Read_Join_06 (void)
{
	m_szName		= "OLTP Read Join 06";
	m_szDescription = "select distinct uniques.u_signed, uniques.u_name, fourram.p_signed, fourram.p_name from uniques, fourram where uniques.u_key = fourram.p_key and uniques.u_code like 'AA%'";
	m_szSQL			= "select distinct uniques.u_signed, uniques.u_name, fourram.p_signed, fourram.p_name from uniques, fourram where uniques.u_key = fourram.p_key and uniques.u_code like 'AA%'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+06;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_06::~CXact_OLTP_Read_Join_06 (void)
{
}

BOOL CXact_OLTP_Read_Join_06::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_06::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_06::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_06 {
		SQLINTEGER u_signed;
		SQLCHAR u_name[25];
		SQLINTEGER p_signed;
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_JOIN_06 OLTP_READ_JOIN_06;
	struct OLTP_READ_JOIN_06_INDICATORS {
		SQLINTEGER u_signed;
		SQLINTEGER u_name;
		SQLINTEGER p_signed;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_JOIN_06_INDICATORS OLTP_READ_JOIN_06_INDICATORS;
	OLTP_READ_JOIN_06 oltp_read_join_06_array[NUM_ROWS];
	OLTP_READ_JOIN_06_INDICATORS oltp_read_join_06_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_06_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_06_array[0].u_signed, sizeof(oltp_read_join_06_array[0].u_signed), &oltp_read_join_06_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_06_array[0].u_name, sizeof(oltp_read_join_06_array[0].u_name), &oltp_read_join_06_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_06_array[0].p_signed, sizeof(oltp_read_join_06_array[0].p_signed), &oltp_read_join_06_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, &oltp_read_join_06_array[0].p_name, sizeof(oltp_read_join_06_array[0].p_name), &oltp_read_join_06_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_06_array[iRowLoop].u_signed << tab
					<< oltp_read_join_06_array[iRowLoop].u_name << tab
					<< oltp_read_join_06_array[iRowLoop].p_signed << tab
					<< oltp_read_join_06_array[iRowLoop].p_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_07

CXact_OLTP_Read_Join_07::CXact_OLTP_Read_Join_07 (void)
{
	m_szName		= "OLTP Read Join 07";
	m_szDescription = "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_key = hundred.h_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_key = hundred.h_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+07;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_07::~CXact_OLTP_Read_Join_07 (void)
{
}

BOOL CXact_OLTP_Read_Join_07::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_07::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_07::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_07 {
		SQLINTEGER u_signed;
		SQLCHAR u_name[25];
		SQLINTEGER h_signed;
		SQLCHAR h_name[25];
	};
	typedef struct OLTP_READ_JOIN_07 OLTP_READ_JOIN_07;
	struct OLTP_READ_JOIN_07_INDICATORS {
		SQLINTEGER u_signed;
		SQLINTEGER u_name;
		SQLINTEGER h_signed;
		SQLINTEGER h_name;
	};
	typedef struct OLTP_READ_JOIN_07_INDICATORS OLTP_READ_JOIN_07_INDICATORS;
	OLTP_READ_JOIN_07 oltp_read_join_07_array[NUM_ROWS];
	OLTP_READ_JOIN_07_INDICATORS oltp_read_join_07_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_07_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_07_array[0].u_signed, sizeof(oltp_read_join_07_array[0].u_signed), &oltp_read_join_07_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_07_array[0].u_name, sizeof(oltp_read_join_07_array[0].u_name), &oltp_read_join_07_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_07_array[0].h_signed, sizeof(oltp_read_join_07_array[0].h_signed), &oltp_read_join_07_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, &oltp_read_join_07_array[0].h_name, sizeof(oltp_read_join_07_array[0].h_name), &oltp_read_join_07_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_07_array[iRowLoop].u_signed << tab
					<< oltp_read_join_07_array[iRowLoop].u_name << tab
					<< oltp_read_join_07_array[iRowLoop].h_signed << tab
					<< oltp_read_join_07_array[iRowLoop].h_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_08

CXact_OLTP_Read_Join_08::CXact_OLTP_Read_Join_08 (void)
{
	m_szName		= "OLTP Read Join 08";
	m_szDescription = "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_code = hundred.h_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_code = hundred.h_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+8;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_08::~CXact_OLTP_Read_Join_08 (void)
{
}

BOOL CXact_OLTP_Read_Join_08::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_08::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_08::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_08 {
		SQLINTEGER u_signed;
		SQLCHAR u_name[25];
		SQLINTEGER h_signed;
		SQLCHAR h_name[25];
	};
	typedef struct OLTP_READ_JOIN_08 OLTP_READ_JOIN_08;
	struct OLTP_READ_JOIN_08_INDICATORS {
		SQLINTEGER u_signed;
		SQLINTEGER u_name;
		SQLINTEGER h_signed;
		SQLINTEGER h_name;
	};
	typedef struct OLTP_READ_JOIN_08_INDICATORS OLTP_READ_JOIN_08_INDICATORS;
	OLTP_READ_JOIN_08 oltp_read_join_08_array[NUM_ROWS];
	OLTP_READ_JOIN_08_INDICATORS oltp_read_join_08_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_08_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_08_array[0].u_signed, sizeof(oltp_read_join_08_array[0].u_signed), &oltp_read_join_08_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_08_array[0].u_name, sizeof(oltp_read_join_08_array[0].u_name), &oltp_read_join_08_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_08_array[0].h_signed, sizeof(oltp_read_join_08_array[0].h_signed), &oltp_read_join_08_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, &oltp_read_join_08_array[0].h_name, sizeof(oltp_read_join_08_array[0].h_name), &oltp_read_join_08_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_08_array[iRowLoop].u_signed << tab
					<< oltp_read_join_08_array[iRowLoop].u_name << tab
					<< oltp_read_join_08_array[iRowLoop].h_signed << tab
					<< oltp_read_join_08_array[iRowLoop].h_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_09

CXact_OLTP_Read_Join_09::CXact_OLTP_Read_Join_09 (void)
{
	m_szName		= "OLTP Read Join 09";
	m_szDescription = "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+9;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_09::~CXact_OLTP_Read_Join_09 (void)
{
}

BOOL CXact_OLTP_Read_Join_09::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_09::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_09::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_09 {
		SQLINTEGER u_signed;
		SQLCHAR u_date[35];
		SQLINTEGER h_signed;
		SQLCHAR h_date[35];
		SQLINTEGER t_signed;
		SQLCHAR t_date[35];
	};
	typedef struct OLTP_READ_JOIN_09 OLTP_READ_JOIN_09;
	struct OLTP_READ_JOIN_09_INDICATORS {
		SQLINTEGER u_signed;
		SQLINTEGER u_date;
		SQLINTEGER h_signed;
		SQLINTEGER h_date;
		SQLINTEGER t_signed;
		SQLINTEGER t_date;
	};
	typedef struct OLTP_READ_JOIN_09_INDICATORS OLTP_READ_JOIN_09_INDICATORS;
	OLTP_READ_JOIN_09 oltp_read_join_09_array[NUM_ROWS];
	OLTP_READ_JOIN_09_INDICATORS oltp_read_join_09_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_09_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_09_array[0].u_signed, sizeof(oltp_read_join_09_array[0].u_signed), &oltp_read_join_09_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_09_array[0].u_date, sizeof(oltp_read_join_09_array[0].u_date), &oltp_read_join_09_indicators_array[0].u_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_09_array[0].h_signed, sizeof(oltp_read_join_09_array[0].h_signed), &oltp_read_join_09_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, oltp_read_join_09_array[0].h_date, sizeof(oltp_read_join_09_array[0].h_date), &oltp_read_join_09_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_SLONG, &oltp_read_join_09_array[0].t_signed, sizeof(oltp_read_join_09_array[0].t_signed), &oltp_read_join_09_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_join_09_array[0].t_date, sizeof(oltp_read_join_09_array[0].t_date), &oltp_read_join_09_indicators_array[0].t_date);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_09_array[iRowLoop].u_signed << tab
					<< oltp_read_join_09_array[iRowLoop].u_date << tab
					<< oltp_read_join_09_array[iRowLoop].h_signed << tab
					<< oltp_read_join_09_array[iRowLoop].h_date << tab
					<< oltp_read_join_09_array[iRowLoop].t_signed << tab
					<< oltp_read_join_09_array[iRowLoop].t_date << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_10

CXact_OLTP_Read_Join_10::CXact_OLTP_Read_Join_10 (void)
{
	m_szName		= "OLTP Read Join 10";
	m_szDescription = "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+10;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_10::~CXact_OLTP_Read_Join_10 (void)
{
}

BOOL CXact_OLTP_Read_Join_10::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_10::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_10::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_10 {
		SQLINTEGER u_signed;
		SQLCHAR u_date[35];
		SQLINTEGER h_signed;
		SQLCHAR h_date[35];
		SQLINTEGER t_signed;
		SQLCHAR t_date[35];
	};
	typedef struct OLTP_READ_JOIN_10 OLTP_READ_JOIN_10;
	struct OLTP_READ_JOIN_10_INDICATORS {
		SQLINTEGER u_signed;
		SQLINTEGER u_date;
		SQLINTEGER h_signed;
		SQLINTEGER h_date;
		SQLINTEGER t_signed;
		SQLINTEGER t_date;
	};
	typedef struct OLTP_READ_JOIN_10_INDICATORS OLTP_READ_JOIN_10_INDICATORS;
	OLTP_READ_JOIN_10 oltp_read_join_10_array[NUM_ROWS];
	OLTP_READ_JOIN_10_INDICATORS oltp_read_join_10_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_10_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_10_array[0].u_signed, sizeof(oltp_read_join_10_array[0].u_signed), &oltp_read_join_10_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_10_array[0].u_date, sizeof(oltp_read_join_10_array[0].u_date), &oltp_read_join_10_indicators_array[0].u_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_10_array[0].h_signed, sizeof(oltp_read_join_10_array[0].h_signed), &oltp_read_join_10_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, oltp_read_join_10_array[0].h_date, sizeof(oltp_read_join_10_array[0].h_date), &oltp_read_join_10_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_SLONG, &oltp_read_join_10_array[0].t_signed, sizeof(oltp_read_join_10_array[0].t_signed), &oltp_read_join_10_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_join_10_array[0].t_date, sizeof(oltp_read_join_10_array[0].t_date), &oltp_read_join_10_indicators_array[0].t_date);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_10_array[iRowLoop].u_signed << tab
					<< oltp_read_join_10_array[iRowLoop].u_date << tab
					<< oltp_read_join_10_array[iRowLoop].h_signed << tab
					<< oltp_read_join_10_array[iRowLoop].h_date << tab
					<< oltp_read_join_10_array[iRowLoop].t_signed << tab
					<< oltp_read_join_10_array[iRowLoop].t_date << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_11

CXact_OLTP_Read_Join_11::CXact_OLTP_Read_Join_11 (void)
{
	m_szName		= "OLTP Read Join 11";
	m_szDescription = "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = updates.p_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = updates.p_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+11;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_11::~CXact_OLTP_Read_Join_11 (void)
{
}

BOOL CXact_OLTP_Read_Join_11::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_11::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_11::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_11 {
		SQLCHAR u_date[35];
		SQLCHAR h_date[35];
		SQLCHAR t_date[35];
		SQLCHAR p_date[35];
	};
	typedef struct OLTP_READ_JOIN_11 OLTP_READ_JOIN_11;
	struct OLTP_READ_JOIN_11_INDICATORS {
		SQLINTEGER u_date;
		SQLINTEGER h_date;
		SQLINTEGER t_date;
		SQLINTEGER p_date;
	};
	typedef struct OLTP_READ_JOIN_11_INDICATORS OLTP_READ_JOIN_11_INDICATORS;
	OLTP_READ_JOIN_11 oltp_read_join_11_array[NUM_ROWS];
	OLTP_READ_JOIN_11_INDICATORS oltp_read_join_11_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_11_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_CHAR, oltp_read_join_11_array[0].u_date, sizeof(oltp_read_join_11_array[0].u_date), &oltp_read_join_11_indicators_array[0].u_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_11_array[0].h_date, sizeof(oltp_read_join_11_array[0].h_date), &oltp_read_join_11_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_11_array[0].t_date, sizeof(oltp_read_join_11_array[0].t_date), &oltp_read_join_11_indicators_array[0].t_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, oltp_read_join_11_array[0].p_date, sizeof(oltp_read_join_11_array[0].p_date), &oltp_read_join_11_indicators_array[0].p_date);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_11_array[iRowLoop].u_date << tab
					<< oltp_read_join_11_array[iRowLoop].h_date << tab
					<< oltp_read_join_11_array[iRowLoop].t_date << tab
					<< oltp_read_join_11_array[iRowLoop].p_date << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_12

CXact_OLTP_Read_Join_12::CXact_OLTP_Read_Join_12 (void)
{
	m_szName		= "OLTP Read Join 12";
	m_szDescription = "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = updates.p_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = updates.p_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+12;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_12::~CXact_OLTP_Read_Join_12 (void)
{
}

BOOL CXact_OLTP_Read_Join_12::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_12::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_12::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_12 {
		SQLCHAR u_date[35];
		SQLCHAR h_date[35];
		SQLCHAR t_date[35];
		SQLCHAR p_date[35];
	};
	typedef struct OLTP_READ_JOIN_12 OLTP_READ_JOIN_12;
	struct OLTP_READ_JOIN_12_INDICATORS {
		SQLINTEGER u_date;
		SQLINTEGER h_date;
		SQLINTEGER t_date;
		SQLINTEGER p_date;
	};
	typedef struct OLTP_READ_JOIN_12_INDICATORS OLTP_READ_JOIN_12_INDICATORS;
	OLTP_READ_JOIN_12 oltp_read_join_12_array[NUM_ROWS];
	OLTP_READ_JOIN_12_INDICATORS oltp_read_join_12_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_12_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_CHAR, oltp_read_join_12_array[0].u_date, sizeof(oltp_read_join_12_array[0].u_date), &oltp_read_join_12_indicators_array[0].u_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_12_array[0].h_date, sizeof(oltp_read_join_12_array[0].h_date), &oltp_read_join_12_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_join_12_array[0].t_date, sizeof(oltp_read_join_12_array[0].t_date), &oltp_read_join_12_indicators_array[0].t_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, oltp_read_join_12_array[0].p_date, sizeof(oltp_read_join_12_array[0].p_date), &oltp_read_join_12_indicators_array[0].p_date);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_12_array[iRowLoop].u_date << tab
					<< oltp_read_join_12_array[iRowLoop].h_date << tab
					<< oltp_read_join_12_array[iRowLoop].t_date << tab
					<< oltp_read_join_12_array[iRowLoop].p_date << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_12_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_13

CXact_OLTP_Read_Join_13::CXact_OLTP_Read_Join_13 (void)
{
	m_szName		= "OLTP Read Join 13";
	m_szDescription = "select uniques.u_int, uniques.u_name from uniques where uniques.u_key <= 2000000 and uniques.u_signed > (select avg(tenpct.t_signed) from tenpct where uniques.u_key = tenpct.t_key) order by u_int";
	m_szSQL			= "select uniques.u_int, uniques.u_name from uniques where uniques.u_key <= 2000000 and uniques.u_signed > (select avg(tenpct.t_signed) from tenpct where uniques.u_key = tenpct.t_key) order by u_int";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+13;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_13::~CXact_OLTP_Read_Join_13 (void)
{
}

BOOL CXact_OLTP_Read_Join_13::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_13::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_13::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_13 {
		SQLINTEGER u_int;
		SQLCHAR u_name[25];
	};
	typedef struct OLTP_READ_JOIN_13 OLTP_READ_JOIN_13;
	struct OLTP_READ_JOIN_13_INDICATORS {
		SQLINTEGER u_int;
		SQLINTEGER u_name;
	};
	typedef struct OLTP_READ_JOIN_13_INDICATORS OLTP_READ_JOIN_13_INDICATORS;
	OLTP_READ_JOIN_13 oltp_read_join_13_array[NUM_ROWS];
	OLTP_READ_JOIN_13_INDICATORS oltp_read_join_13_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_13_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_13_array[0].u_int, sizeof(oltp_read_join_13_array[0].u_int), &oltp_read_join_13_indicators_array[0].u_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_13_array[0].u_name, sizeof(oltp_read_join_13_array[0].u_name), &oltp_read_join_13_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_13_array[iRowLoop].u_int << tab
					<< oltp_read_join_13_array[iRowLoop].u_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_13_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_14

CXact_OLTP_Read_Join_14::CXact_OLTP_Read_Join_14 (void)
{
	m_szName		= "OLTP Read Join 14";
#if (_USE_OUTER_JOINS_ == TRUE)
	m_szDescription = "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from {oj tenthou left outer join tenpct on tenthou.t_code = tenpct.t_code} where tenthou.t_key <= 1000000";
	m_szSQL			= "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from {oj tenthou left outer join tenpct on tenthou.t_code = tenpct.t_code} where tenthou.t_key <= 1000000";
#else
	m_szDescription = "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from tenthou, tenpct where (tenthou.t_code = tenpct.t_code) and (tenthou.t_key <= 1000000) union select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, NULL from tenthou where not exists (select * from tenpct where (tenthou.t_code = tenpct.t_code) and (tenthou.t_key <= 1000000))";
	m_szSQL			= "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from tenthou, tenpct where (tenthou.t_code = tenpct.t_code) and (tenthou.t_key <= 1000000) union select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, NULL from tenthou where not exists (select * from tenpct where (tenthou.t_code = tenpct.t_code) and (tenthou.t_key <= 1000000))";
#endif
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+14;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_14::~CXact_OLTP_Read_Join_14 (void)
{
}

BOOL CXact_OLTP_Read_Join_14::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_14::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_14::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_JOIN_14 {
		SQLINTEGER tenthou_t_key;
		SQLCHAR t_name[25];
		SQLINTEGER t_signed;
		SQLCHAR t_code[15];
		SQLINTEGER tenpct_t_key;
	};
	typedef struct OLTP_READ_JOIN_14 OLTP_READ_JOIN_14;
	struct OLTP_READ_JOIN_14_INDICATORS {
		SQLINTEGER tenthou_t_key;
		SQLINTEGER t_name;
		SQLINTEGER t_signed;
		SQLINTEGER t_code;
		SQLINTEGER tenpct_t_key;
	};
	typedef struct OLTP_READ_JOIN_14_INDICATORS OLTP_READ_JOIN_14_INDICATORS;
	OLTP_READ_JOIN_14 oltp_read_join_14_array[NUM_ROWS];
	OLTP_READ_JOIN_14_INDICATORS oltp_read_join_14_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_join_14_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_join_14_array[0].tenthou_t_key, sizeof(oltp_read_join_14_array[0].tenthou_t_key), &oltp_read_join_14_indicators_array[0].tenthou_t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_join_14_array[0].t_name, sizeof(oltp_read_join_14_array[0].t_name), &oltp_read_join_14_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_join_14_array[0].t_signed, sizeof(oltp_read_join_14_array[0].t_signed), &oltp_read_join_14_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_CHAR, oltp_read_join_14_array[0].t_code, sizeof(oltp_read_join_14_array[0].t_code), &oltp_read_join_14_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_SLONG, &oltp_read_join_14_array[0].tenpct_t_key, sizeof(oltp_read_join_14_array[0].tenpct_t_key), &oltp_read_join_14_indicators_array[0].tenpct_t_key);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_join_14_array[iRowLoop].tenthou_t_key << tab
					<< oltp_read_join_14_array[iRowLoop].t_name << tab
					<< oltp_read_join_14_array[iRowLoop].t_signed << tab
					<< oltp_read_join_14_array[iRowLoop].t_code << tab
					<< oltp_read_join_14_array[iRowLoop].tenpct_t_key << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_join_14_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}
